**************************************************************************************************
*******************LOCAL INCOME INEQUALITY AND HOUSEHOLD INDEBTEDNESS ****************************
*************************REGRESSION ANALYSIS *****************************************************
*************************DATE: JAN 2022 **********************************************************
*************************AUTHOR: KIM NGUYEN ******************************************************
**************************************************************************************************

clear all
set more off
set maxvar 30000
set matsize 10000

//Load data
use "UnbalancedHH_analytical.dta", clear

//Transform vars
* Intention to move in next 12 mths.
gen IntMove = (mhnyr == 1 | mhnyr == 2)
gen LIntMove = L.IntMove

* Neighboorhood satisfaction
gen neigh_satis =  losatnl
gen ns_indic = 1 if neigh_satis>=7 & neigh_satis!=.
replace  ns_indic = 0 if neigh_satis<7
gen Lns_indic = L.ns_indic

* Community satisfaction
gen localcommun_satis = losatlc
gen lc_satis_ind = 1 if localcommun_satis >=7 & localcommun_satis!=.
replace lc_satis_ind = 0 if localcommun_satis <7
gen Llc_satis_ind = L.lc_satis_ind

//Global vars
global DemCovar "age age2 sex Luni Lkids Ladults Lmarried Lemp Lnilf Lselfemp Duni Dkids Dadults Dmarried Demp Dnilf Dselfemp"
global FinCovar "Lginc Dginc Lassets Dassets Lfinassets Dfinassets Lliqnworth Dliqnworth"
global MacroCovar "Lmedhp Dmedhp Lurate Durate Lmedinc Dmedinc Lmeddebt Dmeddebt"
global HeckInst "LIntMove Lns_indic Llc_satis_ind"	


//Table B2: Effects of a one standard deviation increase in Gini coefficient

*Total debt
eststo m1: quietly heckman Ddebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Mortgage debt
eststo m2: quietly heckman Dmortgagedebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Home debt
eststo m3: quietly heckman Dhomedebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Other property debt
eststo m4: quietly heckman Dopropdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Non-ortgage debt
eststo m5: quietly heckman Dnmdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Credit card debt
eststo m6: quietly heckman Dccdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Hire-purchase debt
eststo m7: quietly heckman Dhiredebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Car debt
eststo m8: quietly heckman Dcardebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Business debt
eststo m9: quietly heckman Dbusdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep
*Investment debt
eststo m10: quietly heckman Dinvdebttoinc dgini $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year, select(nonmovers = $HeckInst $DemCovar $FinCovar $MacroCovar i.hhssa3#c.year) twostep

*save table
esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10 using "Tables\Table B2 - Effects of Change in Gini - Heckman.csv",  b(2) se(2) keep(*dgini*) margin title(Debt regressions) star(* 0.10 ** 0.05 *** 0.01) replace nogaps

